﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using TwoCamWPF.Helpers;
using System.Reflection;


namespace TwoCamWPF.Settings
{
    /// <summary>
    /// Логика взаимодействия для StartSettingsPanel.xaml
    /// </summary>

    public partial class StartSettingsPanel : UserControl
    {
        public StartSettingsPanel()
        {
            InitializeComponent();
            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Инициализация панели StartSettingsPanel");
           
        }

    }
    class StartSettingsModel : BaseViewModel<StartSettings>, ISavedBasedViewModel
    {

        public StartSettingsModel(StartSettings settings): base(settings)
        {
            _AutoRun = settings.AutoRun;
            _RunCollapsed = settings.RunCollapsed;
            _RunDelay = settings.RunDelay;
            _RunAndRecord = settings.RunAndRecord;
            settings.OnSave += (_) => Save(); 
        }

        bool _AutoRun;
        public bool AutoRun
        {

            get { return _AutoRun; }
            set
            {
                _AutoRun = value;
                RaisePropertyChanged("AutoRun");
            }
        }

        bool _RunCollapsed;
        public bool RunCollapsed
        {
            get { return _RunCollapsed; }
            set
            {
                _RunCollapsed = value;
                RaisePropertyChanged("RunCollapsed");
            }
        }

        bool _RunAndRecord;
        public bool RunAndRecord
        {
            get { return _RunAndRecord; }
            set
            {
                _RunAndRecord = value;
                RaisePropertyChanged("RunAndRecord");
            }
        }

        int _RunDelay;
        public int RunDelay
        {
            get { return _RunDelay; }
            set
            {
                _RunDelay = value;
                RaisePropertyChanged("RunDelay");
            }
        }


        void Save()
        {
             _settings.AutoRun =_AutoRun;
            _settings.RunCollapsed = _RunCollapsed ;
            _settings.RunDelay = _RunDelay ;
            _settings.RunAndRecord =  _RunAndRecord ;
        }

        public void Dispose()
        {

        }
    }
}
